@echo off
title CLSTEAM NETWORK STABILIZER - Ultimate Network Optimization
setlocal enabledelayedexpansion

:: Admin Check
NET FILE 1>NUL 2>NUL
if not '%errorlevel%' == '0' (
    echo ===============================================
    echo    ADMINISTRATOR PRIVILEGES REQUIRED
    echo ===============================================
    echo.
    echo This script must be run as Administrator!
    echo.
    echo Please right-click on the script and select:
    echo "Run as administrator"
    echo.
    echo Press any key to exit...
    pause >nul
    exit /b 1
)

:Main
cls
echo ===============================================
echo    CLSTEAM NETWORK STABILIZER - ULTIMATE OPTIMIZATION
echo ===============================================
echo.
echo Starting network stabilization process...
echo.
timeout /t 2 /nobreak >nul

:: Network Interface Detection
echo [1/25] Detecting Network Interfaces...
echo.
netsh interface show interface | findstr "Connected"
echo.

:: Reset Network Stack
echo [2/25] Resetting Network Stack to Defaults...
netsh winsock reset catalog >nul 2>&1 && echo   - Winsock catalog reset
netsh int ip reset >nul 2>&1 && echo   - IP stack reset
netsh int tcp reset >nul 2>&1 && echo   - TCP stack reset
echo [SUCCESS] Network stack reset completed
echo.

:: Flush DNS and Cache
echo [3/25] Clearing DNS Cache and Records...
ipconfig /flushdns >nul 2>&1 && echo   - DNS cache flushed
ipconfig /release >nul 2>&1 && echo   - IP addresses released
ipconfig /renew >nul 2>&1 && echo   - IP addresses renewed
ipconfig /registerdns >nul 2>&1 && echo   - DNS registration refreshed
echo [SUCCESS] DNS operations completed
echo.

:: TCP Global Optimizations
echo [4/25] Optimizing TCP Global Parameters...
netsh int tcp set global rss=enabled >nul 2>&1 && echo   - Receive Side Scaling enabled
netsh int tcp set global chimney=enabled >nul 2>&1 && echo   - TCP Chimney offload enabled
netsh int tcp set global netdma=enabled >nul 2>&1 && echo   - Network DMA enabled
netsh int tcp set global dca=enabled >nul 2>&1 && echo   - Direct Cache Access enabled
netsh int tcp set global autotuninglevel=normal >nul 2>&1 && echo   - Auto-tuning level set to normal
netsh int tcp set global congestionprovider=ctcp >nul 2>&1 && echo   - Compound TCP congestion provider
echo [SUCCESS] TCP global optimization completed
echo.

:: TCP Heuristics Disabling
echo [5/25] Disabling TCP Heuristics...
netsh int tcp set heuristics disabled >nul 2>&1 && echo   - TCP heuristics disabled
echo [SUCCESS] TCP heuristics disabled
echo.

:: TCP Parameters Optimization
echo [6/25] Setting Advanced TCP Parameters...
netsh int tcp set global initialRto=1000 >nul 2>&1 && echo   - Initial RTO set to 1000ms
netsh int tcp set global maxSynRetransmissions=2 >nul 2>&1 && echo   - Max SYN retransmissions set to 2
echo [SUCCESS] Advanced TCP parameters configured
echo.

:: Network Throttling Index
echo [7/25] Removing Network Throttling...
reg add "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Multimedia\SystemProfile" /v "NetworkThrottlingIndex" /t REG_DWORD /d 4294967295 /f >nul 2>&1 && echo   - Network throttling disabled
reg add "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Multimedia\SystemProfile" /v "SystemResponsiveness" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - System responsiveness optimized
echo [SUCCESS] Network throttling removed
echo.

:: Internet Connection Settings
echo [8/25] Optimizing Internet Connection Settings...
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings" /v "MaxConnectionsPerServer" /t REG_DWORD /d 16 /f >nul 2>&1 && echo   - Max connections per server: 16
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings" /v "MaxConnectionsPer1_0Server" /t REG_DWORD /d 16 /f >nul 2>&1 && echo   - Max HTTP 1.0 connections: 16
reg add "HKCU\Software\Microsoft\Windows\CurrentVersion\Internet Settings" /v "MaxConnectionsPerServer" /t REG_DWORD /d 16 /f >nul 2>&1 && echo   - User max connections: 16
echo [SUCCESS] Internet connection settings optimized
echo.

:: DNS Optimization with Multiple Providers
echo [9/25] Setting Optimized DNS Servers...
echo.
echo Configuring Ethernet adapter:
netsh interface ip set dns name="Ethernet" source=static addr=1.1.1.1 >nul 2>&1 && echo   - Primary DNS: 1.1.1.1 (Cloudflare)
netsh interface ip add dns name="Ethernet" addr=1.0.0.1 index=2 >nul 2>&1 && echo   - Secondary DNS: 1.0.0.1 (Cloudflare)
netsh interface ip add dns name="Ethernet" addr=8.8.8.8 index=3 >nul 2>&1 && echo   - Tertiary DNS: 8.8.8.8 (Google)
echo.

echo Configuring Wi-Fi adapter:
netsh interface ip set dns name="Wi-Fi" source=static addr=1.1.1.1 >nul 2>&1 && echo   - Primary DNS: 1.1.1.1 (Cloudflare)
netsh interface ip add dns name="Wi-Fi" addr=1.0.0.1 index=2 >nul 2>&1 && echo   - Secondary DNS: 1.0.0.1 (Cloudflare)
netsh interface ip add dns name="Wi-Fi" addr=8.8.8.8 index=3 >nul 2>&1 && echo   - Tertiary DNS: 8.8.8.8 (Google)
echo [SUCCESS] DNS servers optimized with multiple providers
echo.

:: DNS Cache Optimization
echo [10/25] Optimizing DNS Caching...
reg add "HKLM\SYSTEM\CurrentControlSet\Services\Dnscache\Parameters" /v "MaxCacheEntryTtlLimit" /t REG_DWORD /d 3600 /f >nul 2>&1 && echo   - Max cache TTL: 3600 seconds
reg add "HKLM\SYSTEM\CurrentControlSet\Services\Dnscache\Parameters" /v "MaxSOACacheEntryTtlLimit" /t REG_DWORD /d 300 /f >nul 2>&1 && echo   - Max SOA cache TTL: 300 seconds
echo [SUCCESS] DNS cache optimized
echo.

:: Network Adapter Power Management
echo [11/25] Disabling Power Saving on Network Adapters...
powercfg -setdcvalueindex SCHEME_CURRENT 19ee47ba-8fe1-434d-8a6c-132ffcb6aedc 0 >nul 2>&1 && echo   - DC power saving disabled
powercfg -setacvalueindex SCHEME_CURRENT 19ee47ba-8fe1-434d-8a6c-132ffcb6aedc 0 >nul 2>&1 && echo   - AC power saving disabled
echo [SUCCESS] Network adapter power saving disabled
echo.

:: QoS Packet Scheduler
echo [12/25] Configuring QoS Packet Scheduler...
reg add "HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\QoS" /v "Do not use NLA" /t REG_SZ /d "1" /f >nul 2>&1 && echo   - QoS optimized for performance
echo [SUCCESS] QoS configuration completed
echo.

:: Network Buffer Size Optimization
echo [13/25] Optimizing Network Buffer Sizes...
reg add "HKLM\SYSTEM\CurrentControlSet\Services\AFD\Parameters" /v "DefaultReceiveWindow" /t REG_DWORD /d 65535 /f >nul 2>&1 && echo   - Default receive window: 65535
reg add "HKLM\SYSTEM\CurrentControlSet\Services\AFD\Parameters" /v "DefaultSendWindow" /t REG_DWORD /d 65535 /f >nul 2>&1 && echo   - Default send window: 65535
echo [SUCCESS] Network buffer sizes optimized
echo.

:: MTU Optimization
echo [14/25] Optimizing MTU Settings...
reg add "HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters\Interfaces" /v "MTU" /t REG_DWORD /d 1500 /f >nul 2>&1 && echo   - MTU set to 1500 (standard)
echo [SUCCESS] MTU optimization completed
echo.

:: Dead Gateway Detection
echo [15/25] Configuring Gateway Detection...
reg add "HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters" /v "EnableDeadGWDetect" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Dead gateway detection disabled
echo [SUCCESS] Gateway detection configured
echo.

:: TCP Timestamps
echo [16/25] Optimizing TCP Timestamps...
reg add "HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters" /v "TCP1323Opts" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - TCP timestamps enabled
echo [SUCCESS] TCP timestamps optimized
echo.

:: Network Memory Management
echo [17/25] Optimizing Network Memory...
reg add "HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters" /v "MaxUserPort" /t REG_DWORD /d 65534 /f >nul 2>&1 && echo   - Max user ports: 65534
reg add "HKLM\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters" /v "TcpTimedWaitDelay" /t REG_DWORD /d 30 /f >nul 2>&1 && echo   - TCP wait delay: 30 seconds
echo [SUCCESS] Network memory optimized
echo.

:: SMB Network Optimization
echo [18/25] Optimizing SMB Protocol...
reg add "HKLM\SYSTEM\CurrentControlSet\Services\LanmanServer\Parameters" /v "SizReqBuf" /t REG_DWORD /d 17424 /f >nul 2>&1 && echo   - SMB buffer size optimized
echo [SUCCESS] SMB protocol optimized
echo.

:: Wireless Network Optimization
echo [19/25] Optimizing Wireless Networks...
reg add "HKLM\SYSTEM\CurrentControlSet\Services\Wlansvc\Parameters" /v "BackgroundScanMode" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Background scan mode optimized
reg add "HKLM\SYSTEM\CurrentControlSet\Services\Wlansvc\Parameters" /v "RoamAggressiveness" /t REG_DWORD /d 3 /f >nul 2>&1 && echo   - Roaming aggressiveness set
echo [SUCCESS] Wireless network optimized
echo.

:: Network Location Awareness
echo [20/25] Optimizing Network Location Awareness...
reg add "HKLM\SYSTEM\CurrentControlSet\Services\NlaSvc\Parameters\Internet" /v "EnableActiveProbing" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Active probing enabled
echo [SUCCESS] NLA optimization completed
echo.

:: HTTP Protocol Optimization
echo [21/25] Optimizing HTTP Protocol...
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings\5.0" /v "MaxConnectionsPerServer" /t REG_DWORD /d 16 /f >nul 2>&1 && echo   - HTTP max connections increased
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings" /v "SocketSettings" /t REG_SZ /d "0,0,0,0,1,0,0,0" /f >nul 2>&1 && echo   - Socket settings optimized
echo [SUCCESS] HTTP protocol optimized
echo.

:: SSL/TLS Optimization
echo [22/25] Optimizing SSL/TLS Settings...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\SecurityProviders\SCHANNEL" /v "SendTrustedIssuerList" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - SSL/TLS optimized
echo [SUCCESS] SSL/TLS optimization completed
echo.

:: Network Profile Optimization
echo [23/25] Setting Network to Private Profile...
reg add "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\NetworkList\Profiles" /v "Category" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Network profile set to private
echo [SUCCESS] Network profile optimized
echo.

:: Final Network Reset and Flush
echo [24/25] Performing Final Network Reset...
ipconfig /flushdns >nul 2>&1 && echo   - DNS cache flushed
netsh int ip reset >nul 2>&1 && echo   - IP stack reset
netsh winsock reset >nul 2>&1 && echo   - Winsock reset
echo [SUCCESS] Final network reset completed
echo.

:: Restart Network Services
echo [25/25] Restarting Network Services...
net stop "DNS Client" >nul 2>&1 && echo   - DNS Client service stopped
net start "DNS Client" >nul 2>&1 && echo   - DNS Client service started
net stop "DHCP Client" >nul 2>&1 && echo   - DHCP Client service stopped
net start "DHCP Client" >nul 2>&1 && echo   - DHCP Client service started
echo [SUCCESS] Network services restarted
echo.

:: Completion Message
echo ===============================================
echo    NETWORK STABILIZATION COMPLETE!
echo ===============================================
echo.
echo All network optimizations have been successfully applied!
echo.
echo Summary of network optimizations performed:
echo ✓ Network stack completely reset
echo ✓ DNS cache and records flushed
echo ✓ TCP global parameters optimized
echo ✓ Network throttling disabled
echo ✓ Internet connection settings enhanced
echo ✓ Multiple DNS providers configured
echo ✓ DNS caching optimized
echo ✓ Network adapter power saving disabled
echo ✓ QoS packet scheduler configured
echo ✓ Network buffer sizes increased
echo ✓ MTU settings optimized
echo ✓ Gateway detection improved
echo ✓ TCP timestamps enabled
echo ✓ Network memory management optimized
echo ✓ SMB protocol enhanced
echo ✓ Wireless networks optimized
echo ✓ HTTP and SSL/TLS protocols tuned
echo ✓ Network services restarted
echo.
echo Immediate improvements you should experience:
echo - Lower ping and reduced latency
echo - Faster DNS resolution
echo - More stable connections
echo - Improved download/upload speeds
echo - Better gaming and streaming performance
echo.
echo IMPORTANT: Restart your computer for all changes to take full effect!
echo.
echo CLSTEAM NETWORK STABILIZER
echo Optimization completed at: %date% %time%
echo ===============================================
echo.
echo Press Enter to exit...
pause >nul
exit